package redshift

import (
	"context"
	"time"
)

// Redshift is the interface for interacting with the tahoe replica
type Redshift interface {
	CalculateClips(ctx context.Context, start time.Time, end time.Time) error
	CalculateSessions(ctx context.Context, start time.Time, end time.Time) ([]Session, []Session, error)
	GetRecentSessions(ctx context.Context, start time.Time, end time.Time) ([]Session, error)
	GetRecentSessionsEndingAt(ctx context.Context, start time.Time, end time.Time) ([]Session, error)

	//minute_broadcast
	GetBroadcastIDSessionAggregates(ctx context.Context, start time.Time, end time.Time) ([]BroadcastIDAggregate, error)

	//minute_watched
	GetMinuteWatchedHostRaidAggregates(ctx context.Context, start time.Time, end time.Time) ([]MinuteWatchedHostRaidAggregates, error)

	//channel_concurrents
	GetConcurrentsSessionAggregates(ctx context.Context, start time.Time, end time.Time) ([]ConcurrentAggregates, error)
	GetConcurrentsSessionAggregatesEndingAt(ctx context.Context, start time.Time, end time.Time) ([]ConcurrentAggregates, error)
	GetConcurrentsTimeseries(ctx context.Context, start time.Time, end time.Time) ([]ConcurrentTimeseriesUnit, error)

	//server_follow
	GetNewFollowersSessionAggregates(ctx context.Context, start time.Time, end time.Time) ([]ServerFollowAggregates, error)
	GetNewFollowersSessionAggregatesEndingAt(ctx context.Context, start time.Time, end time.Time) ([]ServerFollowAggregates, error)
	GetNewFollowersTimeseries(ctx context.Context, start time.Time, end time.Time) ([]ServerFollowTimeseriesUnit, error)

	//server_chat_message
	GetChatSessionAggregates(ctx context.Context, start time.Time, end time.Time) ([]ChatAggregates, error)
	GetChatTimeseries(ctx context.Context, start time.Time, end time.Time) ([]ChatTimeseriesUnit, error)

	//video_play
	GetVideoPlayPlatformSessionAggregate(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayPlatformAggregateUnit, error)
	GetVideoPlayGeoSessionAggregate(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayGeoAggregateUnit, error)
	GetVideoPlayReferrerSessionAggregate(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayReferrerAggregateUnit, error)
	GetVideoPlayUniqueSessionAggregate(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayUniqueAggregateUnit, error)
	GetVideoPlayUniqueSessionAggregateEndingAt(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayUniqueAggregateUnit, error)
	GetVideoPlayUniqueTimeseries(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayUniqueTimeseriesUnit, error)
	GetVideoPlayClipsReferrerTimeseries(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayClipsReferrersTimeseriesUnit, error)
	GetVideoPlayClipsReferrerAggregate(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayClipsReferrersAggregates, error)
	GetVideoPlayClipsCreateAggregate(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayClipsCreateAggregates, error)
	GetVideoPlayClipsCreateTimeseries(ctx context.Context, start time.Time, end time.Time) ([]VideoPlayClipsCreatesTimeseriesUnit, error)

	//subscription_purchase_success
	GetSubscriptionPurchaseSuccessAggregates(ctx context.Context, start time.Time, end time.Time) ([]SubscriptionPurchaseSuccessAggregates, error)
	GetSubscriptionPurchaseSuccessAggregatesEndingAt(ctx context.Context, start time.Time, end time.Time) ([]SubscriptionPurchaseSuccessAggregates, error)
	GetSubscriptionPurchaseSuccessTimeSeries(ctx context.Context, start time.Time, end time.Time) ([]SubscriptionPurchaseSuccessTimeseriesUnit, error)

	//commercial
	GetCommercialLengthSessionAggregates(ctx context.Context, start time.Time, end time.Time) ([]CommercialAggregates, error)
	GetCommercialLengthTimeseries(ctx context.Context, start time.Time, end time.Time) ([]CommercialTimeseriesUnit, error)

	//raid_execute
	GetRaidExecuteSessionAggregates(ctx context.Context, start time.Time, end time.Time) ([]RaidExecuteAggregates, error)
	GetRaidExecuteTimeseries(ctx context.Context, start time.Time, end time.Time) ([]RaidExecuteTimeseriesUnit, error)
}
