package redshift

import "time"

const (
	//SQLTimeFormat is how timestamps are formatted in PSQL
	SQLTimeFormat = "2006-01-02 15:04:05"
	day           = 24 * time.Hour
)

//-----------------------------------------------------------------------------------------------------------------//
//-----------------------------Session Based Structs---------------------------------------------------------------//

// Session is how the session table is formatted in tahoe
type Session struct {
	ChannelID        string
	SegmentStartTime time.Time
	SegmentEndTime   time.Time
	IsSegmented      bool
}

// BroadcastIDAggregate contains all broadcastids delimited by ', '
// for a session hash
type BroadcastIDAggregate struct {
	ChannelID        string
	SegmentStartTime time.Time
	BroadcastIDs     string
}

// ConcurrentAggregates contains all the session level aggregates of
// channel_concurrents events
type ConcurrentAggregates struct {
	ChannelID           string
	SegmentStartTime    time.Time
	MaxConcurrents      int64
	AverageConcurrents  float64
	TotalMinutesWatched int64
	PeakCCUTime         time.Time
}

// ChatAggregates contains all the session level aggregates of
// server_chat_message events
type ChatAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	UniqueChatters   int64
	TotalMessages    int64
}

// VideoPlayGeoAggregateUnit contains the geo count for a session
type VideoPlayGeoAggregateUnit struct {
	ChannelID        string
	SegmentStartTime time.Time
	Country          string
	Count            int64
}

// VideoPlayPlatformAggregateUnit contains the platform count for a session
type VideoPlayPlatformAggregateUnit struct {
	ChannelID        string
	SegmentStartTime time.Time
	Platform         string
	Count            int64
}

// VideoPlayReferrerAggregateUnit contains the referrer count for a session
type VideoPlayReferrerAggregateUnit struct {
	ChannelID        string
	SegmentStartTime time.Time
	Type             string
	Source           string
	Count            int64
}

// ServerFollowAggregates contains all the session level aggregates of
// server_follow events
type ServerFollowAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	NewFollowers     int64
}

// VideoPlayUniqueAggregateUnit contains the unique, total count for a session
type VideoPlayUniqueAggregateUnit struct {
	ChannelID        string
	SegmentStartTime time.Time
	TotalViews       int64
	UniqueViews      int64
}

// SubscriptionPurchaseSuccessAggregates contains all the session level aggregates of
// subscription_purchase_success events
type SubscriptionPurchaseSuccessAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	NewSubs          int64
}

// CommercialAggregates contains all the session level aggregates of
// commercial events
type CommercialAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	CommercialLength int64
	CommercialCount  int64
}

// RaidExecuteAggregates contains all the session level aggregates of
// raid_execute events
type RaidExecuteAggregates struct {
	TargetID         string
	SegmentStartTime time.Time
	NumberOfRaids    int64
	ViewersCount     int64
}

// VideoPlayClipsReferrersAggregates contains all the session aggregates of clip
// related video-play events
type VideoPlayClipsReferrersAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	Referrer         string
	Views            int64
}

// VideoPlayClipsCreateAggregates contains all the session aggregates of clip
// creation related create_clip events
type VideoPlayClipsCreateAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	Creates          int64
}

// MinuteWatchedHostRaidAggregates contains all the session aggregates of hostedMW
// raid sourced MW and Total MW (to calculate host/raid %)
type MinuteWatchedHostRaidAggregates struct {
	ChannelID        string
	SegmentStartTime time.Time
	Total            int64
	Hosted           int64
	Raided           int64
}

//-----------------------------------------------------------------------------------------------------------------//
//-----------------------------TimeSeries Based Structs------------------------------------------------------------//

// ConcurrentTimeseriesUnit contains all the timeseries data for spade
// channel_concurrents events
type ConcurrentTimeseriesUnit struct {
	ChannelID          string
	Timestamp          time.Time
	AverageConcurrents float64
}

// ChatTimeseriesUnit contains all the timeseries data for spade
// server_chat_message events
type ChatTimeseriesUnit struct {
	ChannelID      string
	Timestamp      time.Time
	UniqueChatters int64
	TotalMessages  int64
}

// ServerFollowTimeseriesUnit contains all the timeseries data for spade
// server_follow events
type ServerFollowTimeseriesUnit struct {
	ChannelID    string
	Timestamp    time.Time
	NewFollowers int64
}

// VideoPlayUniqueTimeseriesUnit contains all the timeseries data for spade
// video_play unique device events
type VideoPlayUniqueTimeseriesUnit struct {
	ChannelID   string
	Timestamp   time.Time
	UniqueViews int64
	TotalViews  int64
}

// SubscriptionPurchaseSuccessTimeseriesUnit contains all the timeseries data for spade
// subscription_purchase_success events
type SubscriptionPurchaseSuccessTimeseriesUnit struct {
	ChannelID string
	Timestamp time.Time
	NewSubs   int64
}

// CommercialTimeseriesUnit contains all the timeseries data for spade
// commercial events
type CommercialTimeseriesUnit struct {
	ChannelID        string
	Timestamp        time.Time
	CommercialLength int64
	CommercialCount  int64
}

// RaidExecuteTimeseriesUnit contains all the timeseries data for spade
// raid_execute events
type RaidExecuteTimeseriesUnit struct {
	TargetID      string
	Timestamp     time.Time
	NumberOfRaids int64
	ViewersCount  int64
}

// VideoPlayClipsReferrersTimeseriesUnit contains all the timeseries data clip
// related video-play events
type VideoPlayClipsReferrersTimeseriesUnit struct {
	ChannelID string
	Timestamp time.Time
	Referrer  string
	Views     int64
}

// VideoPlayClipsCreatesTimeseriesUnit contains all the timeseries data of clip
// creation related create_clip events
type VideoPlayClipsCreatesTimeseriesUnit struct {
	ChannelID string
	Timestamp time.Time
	Creates   int64
}
