package redshift

import (
	"database/sql"
	"fmt"

	log "github.com/sirupsen/logrus"
)

const (
	driver             = "postgres"
	dataSourceTemplate = "postgres://%s@%s"
)

const (
	sessionsStartingAt = "segment_start_time"
	sessionsEndingAt   = "segment_end_time"
)

// Client is a wrapper for sql.DB.
type Client struct {
	*sql.DB
}

// OpenConnection opens a connection pool to the Redshift database,
// specified by the database credentials and address.
//
// Pinging the database ensures that the connection was established.
func OpenConnection(credentials string, address string) (*Client, error) {
	log.Info("Opening connection to Redshift database at ", address)

	connection := fmt.Sprintf(dataSourceTemplate, credentials, address)
	session, err := sql.Open(driver, connection)
	if err != nil {
		return nil, err
	}

	if err := session.Ping(); err != nil {
		return nil, err
	}

	return &Client{session}, nil
}
