package sqs

import "context"

// SQS sends messages
type SQS interface {
	Add(ctx context.Context, message Message) error
	AddBatch(ctx context.Context, messages []Message, batchName string) error
}

// Message is a struct representing an individual message to send to the SQS Queue
type Message struct {
	Name    string
	Message interface{}
	Type    *string
	Retry   *int
}
