package statsd

import (
	"fmt"
	"time"

	"code.justin.tv/common/gometrics"
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

// Client is the statsd client
type Client struct {
	statsd.Statter
}

const (
	flushInterval        = 1 * time.Second
	gometricsMonitorRate = 1 * time.Second
)

// NewClient instatiates a new statsd client
func NewClient(host string, env string, instance string, instancetype string) (*Client, error) {
	prefix := fmt.Sprintf("cb.semki.%v.%v.%v", env, instancetype, instance)

	statter, err := statsd.NewBufferedClient(host, prefix, flushInterval, 512)
	if err != nil {
		return nil, errors.Wrap(err, "statsd: failed to instantiate buffered client")
	}

	log.Info(fmt.Sprintf("Connected to StatsD at %s with prefix %s", host, prefix))

	gometrics.Monitor(statter, gometricsMonitorRate)

	return &Client{
		Statter: statter,
	}, nil
}
