package httputil

import (
	"net/http"

	log "github.com/sirupsen/logrus"
)

// PanicRecoveryMiddleware is an HTTP middleware that recovers from a panic,
// logs the panic, writes http.StatusInternalServerError.
func PanicRecoveryMiddleware(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, req *http.Request) {
		defer func() {
			if r := recover(); r != nil {
				log.Error("recovered: ", r)

				w.WriteHeader(http.StatusInternalServerError)
			}
		}()

		inner.ServeHTTP(w, req)
	}

	return http.HandlerFunc(middleware)
}
