package clips

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/cb/semki/config"
	"code.justin.tv/cb/semki/internal/stats"

	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

const (
	// Name is the unique name of this stat
	Name = "clips"
	// RewriteHours is the minimum amount of hours of clips we need to overwrite
	// this is because we could have potentially changed a <48hr stream into 3 <=24hr streams
	RewriteHours = 2 * 24 // 2 days
)

// Stat contains the clients the stat needs
type Stat struct {
	Clients *stats.Clients
	Env     string
}

// InitStat prepares a stat for calculation
func InitStat(clients *stats.Clients, env string) *Stat {
	return &Stat{
		Clients: clients,
		Env:     env,
	}
}

// Calculate calculates sessions and sends results to dynamo
func (s *Stat) Calculate(ctx context.Context, start time.Time, end time.Time) error {
	var err error

	if s.Env == config.Production {
		err = s.Clients.Redshift.CalculateClips(ctx, start, end)
	}
	if err != nil {
		msg := fmt.Sprintf("stat %s: redshift query failed", Name)

		log.WithError(err).Error(msg)
		return errors.Wrap(err, msg)
	}

	return nil
}
