// BUILD
multiJob('cb-semki-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/semki', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Build') {
       phaseJob('cb-semki-build-cron') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
      phaseJob('cb-semki-build-ingest') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

freeStyleJob('cb-semki-build-cron') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/semki', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_docker_cron.sh'
  }
}

freeStyleJob('cb-semki-build-ingest') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/semki', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_docker_ingest.sh'
  }
}

// DEPLOYMENT

multiJob('cb-semki-deploy') {
  parameters {
    stringParam 'ENVIRONMENT'
    stringParam 'BRANCH'
    stringParam 'GIT_COMMIT'
    stringParam 'SKADI_ID'
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('cb-semki-deploy-cron') {
        killPhaseCondition('FAILURE')
      }
      phaseJob('cb-semki-deploy-ingest') {
        killPhaseCondition('FAILURE')
      }
    }
  }
}

freeStyleJob('cb-semki-deploy-cron') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/semki', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_beanstalk_cron.sh'
  }
}

freeStyleJob('cb-semki-deploy-ingest') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/semki', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_beanstalk_ingest.sh'
  }
}
