// table containing sessions
resource "aws_dynamodb_table" "sessions" {
  name           = "${var.name}-${var.environment}-sessions"
  read_capacity  = "${var.dynamo_read_capacities["sessions"]}"
  write_capacity = "${var.dynamo_write_capacities["sessions"]}"
  hash_key       = "channel_id"
  range_key      = "segment_start_time"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "segment_start_time"
    type = "S"
  }
}

// tables containing session aggregates
resource "aws_dynamodb_table" "broadcastid-session" {
  name           = "${var.name}-${var.environment}-broadcastid-session"
  read_capacity  = "${var.dynamo_read_capacities["broadcastid-session"]}"
  write_capacity = "${var.dynamo_write_capacities["broadcastid-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "channel-concurrents-session" {
  name           = "${var.name}-${var.environment}-channel-concurrents-session"
  read_capacity  = "${var.dynamo_read_capacities["channel-concurrents-session"]}"
  write_capacity = "${var.dynamo_write_capacities["channel-concurrents-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "server-chat-message-session" {
  name           = "${var.name}-${var.environment}-server-chat-message-session"
  read_capacity  = "${var.dynamo_read_capacities["server-chat-message-session"]}"
  write_capacity = "${var.dynamo_write_capacities["server-chat-message-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "server-follow-session" {
  name           = "${var.name}-${var.environment}-server-follow-session"
  read_capacity  = "${var.dynamo_read_capacities["server-follow-session"]}"
  write_capacity = "${var.dynamo_write_capacities["server-follow-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-platform-session" {
  name           = "${var.name}-${var.environment}-video-play-platform-session"
  read_capacity  = "${var.dynamo_read_capacities["video-play-platform-session"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-platform-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-geo-session" {
  name           = "${var.name}-${var.environment}-video-play-geo-session"
  read_capacity  = "${var.dynamo_read_capacities["video-play-geo-session"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-geo-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-referrer-session" {
  name           = "${var.name}-${var.environment}-video-play-referrer-session"
  read_capacity  = "${var.dynamo_read_capacities["video-play-referrer-session"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-referrer-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-unique-session" {
  name           = "${var.name}-${var.environment}-video-play-unique-session"
  read_capacity  = "${var.dynamo_read_capacities["video-play-unique-session"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-unique-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-clips-referrer-session" {
  name           = "${var.name}-${var.environment}-video-play-clips-referrer-session"
  read_capacity  = "${var.dynamo_read_capacities["video-play-clips-referrer-session"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-clips-referrer-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-clips-create-session" {
  name           = "${var.name}-${var.environment}-video-play-clips-create-session"
  read_capacity  = "${var.dynamo_read_capacities["video-play-clips-create-session"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-clips-create-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "subscription-purchase-success-session" {
  name           = "${var.name}-${var.environment}-subscription-purchase-success-session"
  read_capacity  = "${var.dynamo_read_capacities["subscription-purchase-success-session"]}"
  write_capacity = "${var.dynamo_write_capacities["subscription-purchase-success-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "subscriptions-purchase-success-session" {
  name           = "${var.name}-${var.environment}-subscriptions-purchase-success-session"
  read_capacity  = "${var.dynamo_read_capacities["subscriptions-purchase-success-session"]}"
  write_capacity = "${var.dynamo_write_capacities["subscriptions-purchase-success-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "commercial-session" {
  name           = "${var.name}-${var.environment}-commercial-session"
  read_capacity  = "${var.dynamo_read_capacities["commercial-session"]}"
  write_capacity = "${var.dynamo_write_capacities["commercial-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "raid-execute-session" {
  name           = "${var.name}-${var.environment}-raid-execute-session"
  read_capacity  = "${var.dynamo_read_capacities["raid-execute-session"]}"
  write_capacity = "${var.dynamo_write_capacities["raid-execute-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

resource "aws_dynamodb_table" "minute-watched-hosted-session" {
  name           = "${var.name}-${var.environment}-minute-watched-hosted-session"
  read_capacity  = "${var.dynamo_read_capacities["minute-watched-hosted-session"]}"
  write_capacity = "${var.dynamo_write_capacities["minute-watched-hosted-session"]}"
  hash_key       = "segment_id"

  attribute {
    name = "segment_id"
    type = "S"
  }
}

// tables containing timeseries
resource "aws_dynamodb_table" "channel-concurrents-timeseries" {
  name           = "${var.name}-${var.environment}-channel-concurrents-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["channel-concurrents-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["channel-concurrents-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "server-chat-message-timeseries" {
  name           = "${var.name}-${var.environment}-server-chat-message-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["server-chat-message-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["server-chat-message-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "server-follow-timeseries" {
  name           = "${var.name}-${var.environment}-server-follow-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["server-follow-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["server-follow-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-unique-timeseries" {
  name           = "${var.name}-${var.environment}-video-play-unique-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["video-play-unique-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-unique-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-clips-referrer-timeseries" {
  name           = "${var.name}-${var.environment}-video-play-clips-referrer-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["video-play-clips-referrer-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-clips-referrer-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "video-play-clips-create-timeseries" {
  name           = "${var.name}-${var.environment}-video-play-clips-create-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["video-play-clips-create-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["video-play-clips-create-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "subscription-purchase-success-timeseries" {
  name           = "${var.name}-${var.environment}-subscription-purchase-success-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["subscription-purchase-success-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["subscription-purchase-success-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "subscriptions-purchase-success-timeseries" {
  name           = "${var.name}-${var.environment}-subscriptions-purchase-success-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["subscriptions-purchase-success-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["subscriptions-purchase-success-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "commercial-timeseries" {
  name           = "${var.name}-${var.environment}-commercial-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["commercial-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["commercial-timeseries"]}"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}

resource "aws_dynamodb_table" "raid-execute-timeseries" {
  name           = "${var.name}-${var.environment}-raid-execute-timeseries"
  read_capacity  = "${var.dynamo_read_capacities["raid-execute-timeseries"]}"
  write_capacity = "${var.dynamo_write_capacities["raid-execute-timeseries"]}"
  hash_key       = "target_id"
  range_key      = "timestamp"

  attribute {
    name = "target_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }
}
