# Elastic Beanstalk App
data "aws_iam_policy_document" "app_role_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }

    principals {
      type = "AWS"

      identifiers = [
        "arn:aws:iam::641044725657:role/cb-dashy-production",
        "arn:aws:iam::465369119046:role/cb-dashy-staging",
      ]
    }
  }
}

resource "aws_iam_role" "app" {
  name               = "${var.name}-${var.environment}"
  assume_role_policy = "${data.aws_iam_policy_document.app_role_assume_role_policy.json}"
}

resource "aws_iam_instance_profile" "app" {
  name = "${aws_iam_role.app.name}"
  role = "${aws_iam_role.app.name}"
}

data "aws_iam_policy_document" "worker_tier" {
  statement {
    actions   = ["cloudwatch:PutMetricData"]
    effect    = "Allow"
    resources = ["*"]
  }

  statement {
    actions = [
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
    ]

    effect    = "Allow"
    resources = ["*"]
  }

  statement {
    actions = [
      "sqs:ChangeMessageVisibility",
      "sqs:DeleteMessage",
      "sqs:ReceiveMessage",
      "sqs:SendMessage",
    ]

    effect    = "Allow"
    resources = ["*"]
  }

  statement {
    actions = [
      "s3:Get*",
      "s3:List*",
      "s3:PutObject",
    ]

    effect = "Allow"

    resources = [
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*",
    ]
  }

  statement {
    actions = [
      "dynamodb:BatchGetItem",
      "dynamodb:BatchWriteItem",
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:Query",
      "dynamodb:Scan",
      "dynamodb:UpdateItem",
    ]

    effect    = "Allow"
    resources = ["arn:aws:dynamodb:*:*:table/*-stack-AWSEBWorkerCronLeaderRegistry*"]
  }

  statement {
    actions = [
      "sns:Publish",
    ]

    effect = "Allow"

    resources = [
      "${var.pushy_sns_arn}",
    ]
  }

  statement {
    actions = [
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:GetLogEvents",
      "logs:PutLogEvents",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:PutRetentionPolicy",
    ]

    effect = "Allow"

    resources = [
      "arn:aws:logs:us-west-2:*:*",
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*",
    ]
  }
}

resource "aws_iam_role_policy" "worker_tier" {
  name   = "worker-tier-policy"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.worker_tier.json}"
}

# Sandstorm
data "aws_iam_policy_document" "sandstorm" {
  statement {
    actions   = ["sts:AssumeRole"]
    effect    = "Allow"
    resources = ["${var.sandstorm_iam_role_arn}"]
  }

  statement {
    actions   = ["s3:GetObject"]
    effect    = "Allow"
    resources = ["arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"]
  }
}

resource "aws_iam_role_policy" "sandstorm" {
  name   = "sandstorm-policy"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.sandstorm.json}"
}

# DynamoDB tables
data "aws_iam_policy_document" "dynamodb" {
  statement {
    actions = ["dynamodb:*"]
    effect  = "Allow"

    resources = [
      "${aws_dynamodb_table.sessions.arn}",
      "${aws_dynamodb_table.broadcastid-session.arn}",
      "${aws_dynamodb_table.channel-concurrents-session.arn}",
      "${aws_dynamodb_table.channel-concurrents-timeseries.arn}",
      "${aws_dynamodb_table.server-chat-message-session.arn}",
      "${aws_dynamodb_table.server-chat-message-timeseries.arn}",
      "${aws_dynamodb_table.server-follow-session.arn}",
      "${aws_dynamodb_table.server-follow-timeseries.arn}",
      "${aws_dynamodb_table.video-play-platform-session.arn}",
      "${aws_dynamodb_table.video-play-geo-session.arn}",
      "${aws_dynamodb_table.video-play-referrer-session.arn}",
      "${aws_dynamodb_table.video-play-unique-timeseries.arn}",
      "${aws_dynamodb_table.video-play-unique-session.arn}",
      "${aws_dynamodb_table.video-play-clips-referrer-session.arn}",
      "${aws_dynamodb_table.video-play-clips-referrer-timeseries.arn}",
      "${aws_dynamodb_table.video-play-clips-create-session.arn}",
      "${aws_dynamodb_table.video-play-clips-create-timeseries.arn}",
      "${aws_dynamodb_table.subscriptions-purchase-success-session.arn}",
      "${aws_dynamodb_table.subscriptions-purchase-success-timeseries.arn}",
      "${aws_dynamodb_table.subscription-purchase-success-session.arn}",
      "${aws_dynamodb_table.subscription-purchase-success-timeseries.arn}",
      "${aws_dynamodb_table.commercial-session.arn}",
      "${aws_dynamodb_table.commercial-timeseries.arn}",
      "${aws_dynamodb_table.raid-execute-session.arn}",
      "${aws_dynamodb_table.raid-execute-timeseries.arn}",
      "${aws_dynamodb_table.subscription-purchase-success-timeseries.arn}",
      "${aws_dynamodb_table.minute-watched-hosted-session.arn}",
    ]
  }

  statement {
    actions = ["dynamodb:Query"]
    effect  = "Allow"

    resources = [
      "${aws_dynamodb_table.sessions.arn}/index/*",
      "${aws_dynamodb_table.broadcastid-session.arn}/index/*",
      "${aws_dynamodb_table.channel-concurrents-session.arn}/index/*",
      "${aws_dynamodb_table.channel-concurrents-timeseries.arn}/index/*",
      "${aws_dynamodb_table.server-chat-message-session.arn}/index/*",
      "${aws_dynamodb_table.server-chat-message-timeseries.arn}/index/*",
      "${aws_dynamodb_table.server-follow-session.arn}/index/*",
      "${aws_dynamodb_table.server-follow-timeseries.arn}/index/*",
      "${aws_dynamodb_table.video-play-platform-session.arn}/index/*",
      "${aws_dynamodb_table.video-play-geo-session.arn}/index/*",
      "${aws_dynamodb_table.video-play-referrer-session.arn}/index/*",
      "${aws_dynamodb_table.video-play-unique-session.arn}/index/*",
      "${aws_dynamodb_table.video-play-unique-timeseries.arn}/index/*",
      "${aws_dynamodb_table.video-play-clips-referrer-session.arn}/index/*",
      "${aws_dynamodb_table.video-play-clips-referrer-timeseries.arn}/index/*",
      "${aws_dynamodb_table.video-play-clips-create-session.arn}/index/*",
      "${aws_dynamodb_table.video-play-clips-create-timeseries.arn}/index/*",
      "${aws_dynamodb_table.subscriptions-purchase-success-session.arn}/index/*",
      "${aws_dynamodb_table.subscriptions-purchase-success-timeseries.arn}/index/*",
      "${aws_dynamodb_table.subscription-purchase-success-session.arn}/index/*",
      "${aws_dynamodb_table.subscription-purchase-success-timeseries.arn}/index/*",
      "${aws_dynamodb_table.commercial-session.arn}/index/*",
      "${aws_dynamodb_table.commercial-timeseries.arn}/index/*",
      "${aws_dynamodb_table.raid-execute-session.arn}/index/*",
      "${aws_dynamodb_table.raid-execute-timeseries.arn}/index/*",
      "${aws_dynamodb_table.subscription-purchase-success-timeseries.arn}/index/*",
      "${aws_dynamodb_table.minute-watched-hosted-session.arn}/index/*",
    ]
  }
}

resource "aws_iam_role_policy" "dynamodb" {
  name   = "dynamodb-policy"
  role   = "${aws_iam_role.app.id}"
  policy = "${data.aws_iam_policy_document.dynamodb.json}"
}
