# Worker queues
resource "aws_sqs_queue" "ingest_queue" {
  name = "${var.name}-${var.environment}-ingest-queue"

  visibility_timeout_seconds = "${var.sqs_defaults["visibility_timeout_seconds"]}"
  message_retention_seconds  = "${var.sqs_defaults["message_retention_seconds"]}"

  redrive_policy = <<EOF
{
  "maxReceiveCount":3,
  "deadLetterTargetArn": "${aws_sqs_queue.ingest_queue_dlq.arn}"
}
EOF

  lifecycle {
    prevent_destroy = true
  }
}

resource "aws_sqs_queue" "ingest_queue_dlq" {
  name                      = "${var.name}-${var.environment}-ingest-queue-dlq"
  message_retention_seconds = "${var.sqs_defaults["dead_message_retention_seconds"]}"

  lifecycle {
    prevent_destroy = true
  }
}

# Worker queues
resource "aws_sqs_queue" "cron_queue" {
  name = "${var.name}-${var.environment}-cron-queue"

  visibility_timeout_seconds = "${var.sqs_defaults["visibility_timeout_seconds"]}"
  message_retention_seconds  = "${var.sqs_defaults["message_retention_seconds"]}"

  redrive_policy = <<EOF
{
  "maxReceiveCount":1,
  "deadLetterTargetArn": "${aws_sqs_queue.cron_queue_dlq.arn}"
}
EOF

  lifecycle {
    prevent_destroy = true
  }
}

resource "aws_sqs_queue" "cron_queue_dlq" {
  name                      = "${var.name}-${var.environment}-cron-queue-dlq"
  message_retention_seconds = "${var.sqs_defaults["dead_message_retention_seconds"]}"

  lifecycle {
    prevent_destroy = true
  }
}
