variable "aws_key_name" {
  type    = "string"
  default = "creator-business"
}

variable "aws_profile" {
  type        = "string"
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "account_id" {
  type        = "string"
  default     = "989470033077"
  description = "AWS account id"
}

variable "aws_region" {
  type    = "string"
  default = "us-west-2"
}

variable "environment" {
  type        = "string"
  description = "Service environment"
}

variable "ingest_instance_type" {
  type        = "string"
  default     = "c4.2xlarge"
  description = "Ingest server EC2 instance type"
}

variable "name" {
  type        = "string"
  default     = "cb-semki"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "team_abbreviation" {
  type        = "string"
  default     = "cb"
  description = "Shorthand for Creator Business"
}

variable "owner" {
  type        = "string"
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = "string"
  default     = "cb/semki"
  description = "GitHub repository name"
}

variable "root_volume_size" {
  type        = "string"
  default     = 256
  description = "Amount of diskspace allocated to the root drive (GB)"
}

variable "pushy_sns_arn" {
  type        = "string"
  description = "AWS SNS ARN for pushy events"
}

variable "sandstorm_iam_role_arn" {
  type        = "string"
  description = "AWS IAM Role ARN for assuming the role of the Sandstorm Agent"
}

variable "spade_backlog_size" {
  type        = "string"
  description = "Channel size for Experiments Spade Client"
}

variable "solution_stack_name" {
  type    = "string"
  default = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
}

variable "team" {
  type        = "string"
  default     = "Creator Business"
  description = "Twitch team name"
}

variable "sqs_defaults" {
  type = "map"

  default = {
    visibility_timeout_seconds     = 60
    message_retention_seconds      = 3600   # 1 hour
    dead_message_retention_seconds = 345600 # 4 days
  }
}

variable "connections_per_worker" {
  type        = "string"
  default     = "100"
  description = "amount of simultaneous connections the daemon will allow ea worker instance to have"
}

variable "connection_timeout" {
  type = "map"

  default = {
    "cron"   = 1800
    "ingest" = 60
  }
}

variable "asg_max_size" {
  type = "map"

  default = {
    "cron"   = 1
    "ingest" = 10
  }
}

variable "asg_min_size" {
  type = "map"

  default = {
    "cron"   = 1
    "ingest" = 4
  }
}

# DynamoDB capacities
variable "dynamo_read_capacities" {
  type = "map"

  default = {
    "sessions" = 500

    "broadcastid-session"                    = 500
    "channel-concurrents-session"            = 500
    "server-chat-message-session"            = 500
    "server-follow-session"                  = 500
    "video-play-platform-session"            = 500
    "video-play-geo-session"                 = 500
    "video-play-referrer-session"            = 500
    "video-play-unique-session"              = 500
    "subscription-purchase-success-session"  = 500
    "subscriptions-purchase-success-session" = 500
    "commercial-session"                     = 500
    "raid-execute-session"                   = 500
    "video-play-clips-referrer-session"      = 500
    "video-play-clips-create-session"        = 500
    "minute-watched-hosted-session"          = 500

    "channel-concurrents-timeseries"            = 500
    "server-chat-message-timeseries"            = 500
    "server-follow-timeseries"                  = 500
    "video-play-unique-timeseries"              = 500
    "subscription-purchase-success-timeseries"  = 500
    "subscriptions-purchase-success-timeseries" = 500
    "commercial-timeseries"                     = 500
    "raid-execute-timeseries"                   = 500
    "channels-similar-audience-current"         = 500
    "video-play-clips-referrer-timeseries"      = 500
    "video-play-clips-create-timeseries"        = 500
  }
}

variable "dynamo_write_capacities" {
  type = "map"

  default = {
    "sessions" = 20000

    "broadcastid-session"                    = 15000
    "channel-concurrents-session"            = 8000
    "server-chat-message-session"            = 6000
    "server-follow-session"                  = 5000
    "video-play-platform-session"            = 10000
    "video-play-geo-session"                 = 7000
    "video-play-referrer-session"            = 15000
    "video-play-unique-session"              = 15000
    "subscription-purchase-success-session"  = 250
    "subscriptions-purchase-success-session" = 250
    "commercial-session"                     = 300
    "raid-execute-session"                   = 600
    "video-play-clips-referrer-session"      = 4000
    "video-play-clips-create-session"        = 4000
    "minute-watched-hosted-session"          = 15000

    "channel-concurrents-timeseries"            = 15000
    "server-chat-message-timeseries"            = 6000
    "server-follow-timeseries"                  = 3000
    "video-play-unique-timeseries"              = 20000
    "subscription-purchase-success-timeseries"  = 150
    "subscriptions-purchase-success-timeseries" = 150
    "commercial-timeseries"                     = 200
    "raid-execute-timeseries"                   = 150
    "video-play-clips-referrer-timeseries"      = 2500
    "video-play-clips-create-timeseries"        = 750
  }
}
