terraform {
  required_version = ">= 0.10.0"

  backend "s3" {
    bucket  = "cb-semki-terraform"
    key     = "production/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "semki" {
  source       = "../modules/semki"
  environment  = "production"
  aws_key_name = "cb-semki-production"

  pushy_sns_arn = "arn:aws:sns:us-west-2:603200399373:pushy_production_dispatch"
  sandstorm_iam_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-semki-production"
  spade_backlog_size = "32768"
}

module "pagerduty_production" {
  source = "../modules/pagerduty"

  environment         = "production"
  pagerduty_alert_url = "https://events.pagerduty.com/integration/6a92891e0f5448e9a642ba49b8d9fafd/enqueue"
}
