terraform {
  required_version = ">= 0.10.0"

  backend "s3" {
    bucket  = "cb-semki-terraform"
    key     = "staging/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "semki" {
  source       = "../modules/semki"
  environment  = "staging"
  aws_key_name = "cb-semki-staging"

  pushy_sns_arn = "arn:aws:sns:us-west-2:603200399373:pushy_darklaunch_dispatch"
  sandstorm_iam_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-semki-staging"
  spade_backlog_size = "32768"

  asg_max_size = {
    "cron"   = 1
    "ingest" = 3
  }

  asg_min_size = {
    "cron"   = 1
    "ingest" = 2
  }

  #Dynamo Capacities
  dynamo_read_capacities = {
    "sessions" = 200

    "broadcastid-session"                    = 200
    "channel-concurrents-session"            = 200
    "server-chat-message-session"            = 200
    "server-follow-session"                  = 200
    "video-play-platform-session"            = 200
    "video-play-geo-session"                 = 200
    "video-play-referrer-session"            = 200
    "video-play-unique-session"              = 200
    "subscription-purchase-success-session"  = 200
    "subscriptions-purchase-success-session" = 200
    "commercial-session"                     = 200
    "raid-execute-session"                   = 200
    "video-play-clips-referrer-session"      = 200
    "video-play-clips-create-session"        = 200
    "minute-watched-hosted-session"          = 200

    "channel-concurrents-timeseries"            = 200
    "server-chat-message-timeseries"            = 200
    "server-follow-timeseries"                  = 200
    "video-play-unique-timeseries"              = 200
    "subscription-purchase-success-timeseries"  = 200
    "subscriptions-purchase-success-timeseries" = 200
    "commercial-timeseries"                     = 200
    "raid-execute-timeseries"                   = 200
    "video-play-clips-referrer-timeseries"      = 200
    "video-play-clips-create-timeseries"        = 200
  }

  dynamo_write_capacities = {
    "sessions" = 5000

    "broadcastid-session"                    = 15000
    "channel-concurrents-session"            = 200
    "server-chat-message-session"            = 200
    "server-follow-session"                  = 200
    "video-play-platform-session"            = 200
    "video-play-geo-session"                 = 200
    "video-play-referrer-session"            = 200
    "video-play-unique-session"              = 200
    "subscription-purchase-success-session"  = 200
    "subscriptions-purchase-success-session" = 200
    "commercial-session"                     = 200
    "raid-execute-session"                   = 200
    "video-play-clips-referrer-session"      = 200
    "video-play-clips-create-session"        = 200
    "minute-watched-hosted-session"          = 200

    "channel-concurrents-timeseries"            = 200
    "server-chat-message-timeseries"            = 200
    "server-follow-timeseries"                  = 200
    "video-play-unique-timeseries"              = 200
    "subscription-purchase-success-timeseries"  = 200
    "subscriptions-purchase-success-timeseries" = 200
    "commercial-timeseries"                     = 200
    "raid-execute-timeseries"                   = 200
    "video-play-clips-referrer-timeseries"      = 200
    "video-play-clips-create-timeseries"        = 200
  }
}
