package achievementsinternal

import (
	"context"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

// Client is the client interface for the Achievements service.
type Client interface {
	// GetV1Quests makes a GET request for a channel's quests progress
	GetV1Quests(ctx context.Context, channelID string, params view.V1QuestsRequestParams, reqOpts *twitchclient.ReqOpts) (*view.V1QuestsResponse, error)
}

type client struct {
	twitchclient.Client
}

// NewClient instantiates a new client for the Achievements service.
func NewClient(config twitchclient.ClientConf) (Client, error) {
	if config.TimingXactName == "" {
		config.TimingXactName = "cb-achievements"
	}

	twitchClient, err := twitchclient.NewClient(config)
	if err != nil {
		return nil, err
	}

	return &client{twitchClient}, nil
}
