package achievementsinternal

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1Quests makes a GET request to fetch the progress of all quests for a given channel.
func (c *client) GetV1Quests(ctx context.Context, channelID string, params view.V1QuestsRequestParams, reqOpts *twitchclient.ReqOpts) (*view.V1QuestsResponse, error) {
	path := fmt.Sprintf("/v1/internal/channels/%s/quests", channelID)

	if params.RewardsIncluded != nil {
		path += fmt.Sprintf("?rewards_included=%t", *params.RewardsIncluded)
	}

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-achievements.v1.get_quests",
		StatSampleRate: 0.1,
	})

	response := &view.V1QuestsResponse{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
