package view

import "time"

// V1Progressions is the response for GET /v1/channels/:channel_id/progressions.
type V1Progressions struct {
	Status  int                 `json:"status"`
	Message string              `json:"message"`
	Meta    *V1ProgressionsMeta `json:"meta"`
	Data    *V1ProgressionsData `json:"data"`
}

// V1ProgressionsMeta contains the meta data for V1Progressions.
type V1ProgressionsMeta struct {
}

// V1ProgressionsData contains the data for V1Progressions.
type V1ProgressionsData struct {
	Achievements []*V1ProgressionsAchievement `json:"achievements"`
}

// V1ProgressionsAchievement is an achievement with a channel's progression,
// contained in a list for V1ProgressionsData.
type V1ProgressionsAchievement struct {
	ID          string     `json:"id"`
	Key         string     `json:"key"`
	Level       int        `json:"level"`
	Progress    int        `json:"progress"`
	ProgressCap int        `json:"progress_cap"`
	Image       string     `json:"image"`
	ImageSm     string     `json:"image-sm"`
	Image2x     string     `json:"image-2x"`
	Image3x     string     `json:"image-3x"`
	CompletedAt *time.Time `json:"completed_at"`
}
