package view

import "time"

// V1QuestsRequestParams includes optional parameters to include in the request to the GetV1Quests API.
type V1QuestsRequestParams struct {
	RewardsIncluded *bool
}

// V1QuestsResponse contains the response for the quests route
type V1QuestsResponse struct {
	Meta *V1QuestsMeta `json:"meta"`
	Data *V1QuestsData `json:"data"`
}

// V1QuestsMeta contains the metadata for the quests route
type V1QuestsMeta struct {
}

// V1QuestsData contains the quest data for the quests route
type V1QuestsData struct {
	Quests []*V1Quest `json:"quests"`
}

// V1Quest contains information about the progress of a quest
type V1Quest struct {
	Key           string             `json:"key"`
	Reward        *V1QuestRewardTier `json:"reward"`
	Image         string             `json:"image"`
	IsInviteError bool               `json:"is_invite_error"`
	IsComplete    bool               `json:"is_complete"`
	CompletedAt   *time.Time         `json:"completed_at"`
	Progress      []*V1QuestProgress `json:"progress"`
}

// V1QuestRewardTier contains the tiers and reward caps for a quest
type V1QuestRewardTier struct {
	Tier  int `json:"tier"`
	Limit int `json:"limit"`
}

// V1QuestProgress contains various progress metrics for quests.
type V1QuestProgress struct {
	Metric      string  `json:"metric"`
	TimeBased   bool    `json:"time_based"`
	Progress    float64 `json:"progress"`
	ProgressCap float64 `json:"progress_cap"`
}
