package clipsv2

import "time"

// Clip is a client-friendly representation of a Clip
type Clip struct {
	ID        string `json:"id"`
	Slug      string `json:"slug"`
	URL       string `json:"url"`
	EmbedURL  string `json:"embed_url"`
	EmbedHTML string `json:"embed_html"`
	ViewURL   string `json:"view_url"`

	BroadcasterID          string  `json:"broadcaster_id"`
	BroadcasterDisplayName string  `json:"broadcaster_display_name"`
	BroadcasterLogin       string  `json:"broadcaster_login"`
	BroadcasterChannelURL  string  `json:"broadcaster_channel_url"`
	BroadcasterLogo        *string `json:"broadcaster_logo"`
	CuratorID              string  `json:"curator_id"`
	CuratorDisplayName     string  `json:"curator_display_name"`
	CuratorLogin           string  `json:"curator_login"`
	CuratorChannelURL      string  `json:"curator_channel_url"`
	CuratorLogo            *string `json:"curator_logo"`

	VodID              *string `json:"vod_id"`
	VodURL             *string `json:"vod_url"`
	VodOffset          *int64  `json:"vod_offset"`
	VodPreviewImageURL *string `json:"vod_preview_image_url"`
	BroadcastID        *string `json:"broadcast_id"`

	Game        string    `json:"game"`
	Communities []string  `json:"communities"`
	Title       string    `json:"title"`
	Views       int64     `json:"views"`
	Duration    float64   `json:"duration"`
	CreatedAt   time.Time `json:"created_at"`
	Language    string    `json:"language"`

	Thumbnails map[string]string `json:"thumbnails"`
}

// Status is the client-friendly representation of a Clip's status.
type Status struct {
	Status         string           `json:"status"`
	QualityOptions []QualityOptions `json:"quality_options"`
}

// QualityOptions is the client-friendly representation of a Clip's quality options.
type QualityOptions struct {
	Quality string `json:"quality"`
	Source  string `json:"source"`
}

// ClipCount is the client-friendly representation of a broadcast's clip count.
type ClipCount struct {
	Count int `json:"count"`
}
