package utils

import (
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

func ConstructSingleClipTwitchError(resp *http.Response) error {
	if resp.StatusCode == http.StatusForbidden {
		return &twitchclient.Error{StatusCode: http.StatusForbidden, Message: "this channel has been closed due to terms of service violation"}
	} else if resp.StatusCode == http.StatusNotFound {
		return &twitchclient.Error{StatusCode: http.StatusNotFound, Message: "clip not found"}
	}

	return twitchclient.HandleFailedResponse(resp)
}

func StatusCode(inErr error) int {
	switch err := inErr.(type) {
	case *twitchclient.Error:
		return err.StatusCode
	}
	return 0
}
