# API

## CREATE

Creates an audit for a channel. It expects a JSON dictionary as the request body.

### Request

```sh
curl -X POST \
-H "Content-Type: application/json" \
-d "{\"actor_id\": 85901348, \"action\": \"status_change\", \"obj_id\": 85901348, \"old_value\": \"123\", \"new_value\": \"456\"}" \
http://localhost:9292/v1/channel_audits/123
```

* **actor_id** - The user_id that performed the action being audited
* **action** - The kind of action performed
* **obj_id** - The user which the action is targeting
* **old_value** (optional) - the old value before the action resolved
* **new_value** (optional) - the new value after the action resolved

### Response

Empty Response

---

## GET

Fetches channel audits for a given channel

### Request

```sh
curl -X GET \
http://channel-audits.staging.us-west2.twitch.tv/v1/channel_audits/85901348?limit=2
```

#### Optional Query Parameters

* `limit` The maximum number of results to return
  * default: 10
* `cursor` A cursor for paging through audits
  * The cursor value for the followup request is the last id of the previous request
  * default: nil

### Response

```json
[
  {
    "id":133286205,
    "channel_id":85901348,
    "actor_id":85901348,
    "obj_id":85901348,
    "action":"status_change",
    "new_value":"Test12223 asdfasdf",
    "created_on":"2016-04-29T21:13:38.906Z",
    "old_value":"Test12223",
    "undoable":true
  },
  {
    "id":133285178,
    "channel_id":85901348,
    "actor_id":85901348,
    "obj_id":85901348,
    "action":"game_change",
    "new_value":"Diablo III: Reaper of Souls",
    "created_on":"2016-04-28T23:43:20.380Z",
    "old_value":"Hearthstone: Heroes of Warcraft",
    "undoable":true
  }
]
```

#### Cursor Example
The last id from the previous query is **133285178**, so the cursor is **133285178**

##### Request

```sh
curl -X GET \
http://channel-audits.staging.us-west2.twitch.tv/v1/channel_audits/85901348?limit=2&cursor=133285178
```

##### Response

```json
[
  {
    "id":133285177,
    "channel_id":85901348,
    "actor_id":85901348,
    "obj_id":85901348,
    "action":"game_change",
    "new_value":"Hearthstone: Heroes of Warcraft",
    "created_on":"2016-04-28T23:43:13.999Z",
    "old_value":"Diablo III: Reaper of Souls",
    "undoable":true
  },
  {
    "id":133285176,
    "channel_id":85901348,
    "actor_id":85901348,
    "obj_id":85901348,
    "action":"status_change",
    "new_value":"Test123aa adsfadfasdf%",
    "created_on":"2016-04-28T23:43:03.735Z",
    "old_value":"Test123aa",
    "undoable":true
  }
]
```
