## Watchers Runbook
This describes the different components of Watchers and how to operate them.

[twitch-cb-aws account](https://twitch-cb-aws.signin.aws.amazon.com/console)
[Pagerduty](https://twitchoncall.pagerduty.com/services/P6OQR50)
[Service Catalog](https://status.internal.justin.tv/services/58)
[Github](https://git.xarth.tv/cb/watchers)
[clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/watchers)

### Deploying and Rollbacks
See the deployment [docs](deployment.md) for help with deploying and rolling back.

### Monitoring and Errors
Errors are logged to [rollbar](https://rollbar.com/Twitch/CB_Watchers/items/).
There is a Grafana dashboard [here](https://grafana.internal.justin.tv/d/XLPAxjaik/cb-watchers).
Beanstalk apps can also be monitored from the AWS console
1. [Web](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-watchers-production&environmentId=e-emrftv2rmp)
2. [Worker](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-watchers-production&environmentId=e-5kenmayhdq)

### Pagerduty
[Pagerduty](https://twitchoncall.pagerduty.com/services/P6OQR50)
Pagerduty is integrated with Cloudwatch. Pages are sent based on application health.

### Terraform
Infrastructure configuration is done using terraform. All these files live in the [git repo](https://git.xarth.tv/cb/watchers/tree/master/terraform). Changes should be applied to both staging and production, and committed to the repo using a pull request.

### Elastic Beanstalk
Watchers exists as an elastic beanstalk application, for development, staging and production environments.
1. [production](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-watchers-production)
2. [staging](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-watchers-staging)
3. [development](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-watchers-development)

### Storage
Watchers is backed by PostgreSQL running in RDS.  See the recovery [docs](recovery.md) for help with data recovery.

### Cloudwatch
Application health and API latency is monitored through Cloudwatch.
1. [Web health alarm](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-watchers-production-web-health)
1. [Worker health alarm](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-watchers-production-worker-health)
2. [Service latency alarm](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-watchers-production-web-latency)

### Past Alarms
None so far!
