package api

import (
	"code.justin.tv/cb/watchers/internal/authorization"
	"code.justin.tv/cb/watchers/internal/backend"
	"code.justin.tv/feeds/distconf"
	service_common "code.justin.tv/feeds/service-common"
	"goji.io"
	"goji.io/pat"
)

// HTTPServer ...
type HTTPServer struct {
	service_common.BaseHTTPServer

	Auth    *authorization.Decoder
	Config  *HTTPConfig
	Backend backend.Backender
}

// HTTPConfig ...
type HTTPConfig struct {
	service_common.BaseHTTPServerConfig
}

// Load ...
func (c *HTTPConfig) Load(d *distconf.Distconf) error {
	if err := c.BaseHTTPServerConfig.Verify(d, "watchers"); err != nil {
		return err
	}
	return nil
}

// Setup ...
func (s *HTTPServer) Setup() error {
	err := s.BaseHTTPServer.Setup()
	if err != nil {
		return err
	}
	return nil
}

// Routes ...
func (s *HTTPServer) Routes(mux *goji.Mux) {
	mux.Handle(pat.Get("/v1/channel_audits/:channel_id"), s.CreateHandler("v1_channel_audits_get", s.v1Get))
	mux.Handle(pat.Post("/v1/channel_audits/:channel_id"), s.CreateHandler("v1_channel_audits_post", s.v1Create))

	mux.Handle(pat.Get("/v2/channels/:channel_id/audits"), s.CreateHandler("v2_channel_audits_get", s.v2Get))
}
