package api

import (
	"net/http"

	"code.justin.tv/cb/watchers/internal/authorization"
	"code.justin.tv/common/goauthorization"
)

func isAuthorizedChannelID(r *http.Request, decoder *authorization.Decoder, channelID string) error {
	token, err := decoder.ParseToken(r)
	if err != nil {
		return err
	}
	capabilities := goauthorization.CapabilityClaims{
		"view_audits": goauthorization.CapabilityClaim{
			"channel_id": channelID,
		},
	}

	return decoder.Validate(token, capabilities)
}
