package api

import (
	"encoding/json"
	"fmt"
	"math"
	"time"
)

type cachedResponse struct {
	payload interface{}

	cacheTime time.Duration
}

func (c *cachedResponse) Headers() map[string]string {
	cacheTime := int(math.Ceil(c.cacheTime.Seconds()))
	if cacheTime == 0 {
		return nil
	}
	return map[string]string{
		"Cache-Control": fmt.Sprintf("public, max-age=%d", cacheTime),
	}
}

func (c cachedResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(c.payload)
}
