package api

import (
	"encoding/json"
	"errors"
	"fmt"
	"net/http"

	"code.justin.tv/cb/watchers/external/structs"
	"code.justin.tv/feeds/service-common"
	"goji.io/pat"
)

func (s *HTTPServer) v1Create(r *http.Request) (interface{}, error) {
	channelID := pat.Param(r, "channel_id")
	if channelID == "" {
		return nil, &service_common.CodedError{
			Code: http.StatusBadRequest,
			Err:  errors.New("channel id is required"),
		}
	}

	var reqBody structs.V1CreateRequest
	if err := json.NewDecoder(r.Body).Decode(&reqBody); err != nil {
		return nil, &service_common.CodedError{
			Code: http.StatusBadRequest,
			Err:  fmt.Errorf("invalid json request body: %s", err),
		}
	}
	reqBody.ChannelID = channelID

	if err := s.Backend.V1CreateAudit(r.Context(), reqBody); err != nil {
		return nil, &service_common.CodedError{
			Code: http.StatusInternalServerError,
			Err:  fmt.Errorf("error on create audit: %s", err),
		}
	}

	return &structs.V1CreateResponse{}, nil
}
