package authorization

import (
	"code.justin.tv/common/goauthorization"
	"code.justin.tv/feeds/distconf"
	"github.com/pkg/errors"
)

// Decoder is a wrapper for goauthorization.Decoder.
type Decoder struct {
	goauthorization.Decoder
}

// NewDecoder instantiates a Decoder.
func NewDecoder(conf *distconf.Distconf) (*Decoder, error) {
	value := conf.Str("ecc_public_key", "")
	key := []byte(value.Get())

	decoder, err := goauthorization.NewDecoder(algorithm, audience, issuer, key)
	if err != nil {
		return nil, errors.Wrap(err, "authorization: failed to instantiate decoder")
	}

	return &Decoder{decoder}, nil
}
