package authorization

import (
	"io/ioutil"

	"code.justin.tv/feeds/distconf"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

var _ = Describe("Decoder", func() {
	It("errors when the key is invalid", func() {
		key, err := ioutil.ReadFile("development_ecc_private.key")
		Expect(err).NotTo(HaveOccurred())
		reader := &distconf.InMemory{}
		reader.StoreConfig(map[string][]byte{
			"ecc_public_key": key,
		})
		conf := &distconf.Distconf{Readers: []distconf.Reader{reader}}
		decoder, err := NewDecoder(conf)

		Expect(err).To(HaveOccurred())
		Expect(decoder).To(BeNil())
	})

	It("returns a working decoder", func() {
		key, err := ioutil.ReadFile("development_ecc_public.key")
		Expect(err).NotTo(HaveOccurred())
		reader := &distconf.InMemory{}
		reader.StoreConfig(map[string][]byte{
			"ecc_public_key": key,
		})
		conf := &distconf.Distconf{Readers: []distconf.Reader{reader}}
		decoder, err := NewDecoder(conf)

		Expect(err).NotTo(HaveOccurred())
		Expect(decoder).NotTo(BeNil())
	})
})
