package authorization

import (
	"fmt"
	"io/ioutil"

	"code.justin.tv/common/goauthorization"
	"github.com/pkg/errors"
)

// Encoder is a wrapper for goauthorization.Encoder.
type Encoder struct {
	goauthorization.Encoder
}

// NewEncoder instantiates an Encoder.
func NewEncoder(keyPath string) (*Encoder, error) {
	key, err := ioutil.ReadFile(keyPath)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("authorization: failed to read file at %s", keyPath))
	}

	encoder, err := goauthorization.NewEncoder(algorithm, issuer, key)
	if err != nil {
		return nil, errors.Wrap(err, "authorization: failed to instantiate encoder")
	}

	return &Encoder{encoder}, nil
}
