package backend

import (
	"context"

	"code.justin.tv/cb/watchers/external/models"
	"code.justin.tv/cb/watchers/external/structs"
	"code.justin.tv/cb/watchers/internal/datastore"
	"code.justin.tv/feeds/log"
)

// Backender contains functionality that all Backend objects must support.
type Backender interface {
	V1CreateAudit(ctx context.Context, params structs.V1CreateRequest) error
	V1GetAudits(ctx context.Context, params structs.V1GetAuditsRequest) ([]models.ChannelAudit, error)
	V2GetAudits(ctx context.Context, params structs.V2GetAuditsRequest) ([]models.ChannelAudit, error)

	WorkerDeleteUser(ctx context.Context, userID string) error
}

// backend contains datastore and clients to various services.
type backend struct {
	datastore.Datastore

	log *log.ElevatedLog
}

var _ Backender = &backend{}

// NewBackend initializes a backend using the provided datastore.
func NewBackend(datastore datastore.Datastore, logger *log.ElevatedLog) (Backender, error) {
	return &backend{
		Datastore: datastore,
		log:       logger,
	}, nil
}
