package backend

import (
	"context"
	"strconv"

	"code.justin.tv/cb/watchers/external/models"
	"code.justin.tv/cb/watchers/external/structs"
)

func (b *backend) V1CreateAudit(ctx context.Context, params structs.V1CreateRequest) error {
	channelID, err := strconv.ParseInt(params.ChannelID, 10, 64)
	if err != nil {
		return err
	}

	actorID, err := strconv.Atoi(params.ActorID)
	if err != nil {
		return err
	}

	objID, err := strconv.Atoi(params.ObjID)
	if err != nil {
		return err
	}

	// Staging DB has entries for status_change, game_change, commercial, add_editor and remove_editor.
	// Remove_editors and cut are not found.
	// TODO For script: map both remove_editors and remove_editor to auditType=5

	/*
	* enum ChannelAuditType {
	*   UNKNOWN_CHANNEL_AUDIT_TYPE = 0,
	*   TITLE_UPDATE = 1,
	*   GAME_UPDATE = 2,
	*   AD_RUN = 3,
	* 	ADD_EDITOR_UPDATE = 4,
	* 	REMOVE_EDITOR_UPDATE = 5,
	* }
	 */

	auditType := 0 // defaulting to UNKNOWN_CHANNEL_AUDIT_TYPE

	switch params.Action {
	case structs.ActionStatusChange: // TITLE_UPDATE
		auditType = 1
	case structs.ActionGameChange: // GAME_UPDATE
		auditType = 2
	case structs.ActionCommercial: // AD_RUN
		auditType = 3
	case structs.ActionAddEditor: // ADD_EDITOR_UPDATE
		auditType = 4
	case structs.ActionRemoveEditor: // REMOVE_EDITOR_UPDATE
		auditType = 5
	}

	_, err = b.Datastore.CreateAudit(ctx, models.ChannelAudit{
		ChannelID: channelID,
		ActorID:   actorID,
		ObjID:     objID,
		Action:    params.Action,
		NewValue:  params.NewValue,
		OldValue:  params.OldValue,
		AuditType: auditType,
	})

	return err
}
