package backend

import (
	"context"
	"encoding/base64"
	"fmt"

	"code.justin.tv/cb/watchers/external/models"
	"code.justin.tv/cb/watchers/external/structs"
)

func (b *backend) V2GetAudits(ctx context.Context, params structs.V2GetAuditsRequest) ([]models.ChannelAudit, error) {
	var cursor *string
	if params.Cursor != nil {
		bytes, err := base64.StdEncoding.DecodeString(*params.Cursor)
		if err == nil {
			temp := fmt.Sprintf("%s", bytes)
			cursor = &temp
		}
	}

	return b.Datastore.GetAudits(ctx, params.ChannelID, *params.Limit, cursor, nil, nil, nil)
}
