package datastore

import (
	"context"
	"database/sql"
	"time"

	"code.justin.tv/feeds/errors"
)

func (d *datastore) DeleteAuditsByUserID(ctx context.Context, channelID string) error {
	var err error
	defer func(startTime time.Time) {
		d.recordStats(ctx, "deleteAudits", startTime, err == nil)
	}(time.Now())

	_, err = d.ExecContext(ctx, `DELETE FROM channel_audits WHERE channel_id = $1 OR obj_id = $1`, channelID)

	switch {
	case err == sql.ErrNoRows:
		return nil
	case err != nil:
		return errors.Wrapf(err, "could not delete audits %v", channelID)
	}

	return nil
}
