package worker

import (
	"encoding/json"
	"net/http"
	"time"

	"code.justin.tv/cb/watchers/internal/backend"
	"code.justin.tv/feeds/distconf"
	service_common "code.justin.tv/feeds/service-common"
	"goji.io"
	"goji.io/pat"
)

// HTTPServer ...
type HTTPServer struct {
	service_common.BaseHTTPServer

	Config  *HTTPConfig
	Backend backend.Backender
}

// HTTPConfig ...
type HTTPConfig struct {
	service_common.BaseHTTPServerConfig
}

// Load ...
func (c *HTTPConfig) Load(d *distconf.Distconf) error {
	if err := c.BaseHTTPServerConfig.Verify(d, "watchers"); err != nil {
		return err
	}
	return nil
}

// Setup ...
func (s *HTTPServer) Setup() error {
	err := s.BaseHTTPServer.Setup()
	if err != nil {
		return err
	}
	return nil
}

// Routes ...
func (s *HTTPServer) Routes(mux *goji.Mux) {
	mux.Handle(pat.Post("/process"), s.CreateHandler("process", s.process))
}

// Response ...
type Response struct{}

func (s *HTTPServer) process(r *http.Request) (interface{}, error) {
	var reqBody requestBody

	err := json.NewDecoder(r.Body).Decode(&reqBody)
	if err != nil {
		s.Log.Debug(err)
		return nil, err
	}

	var messageBody hardDeleteUserMessage
	err = json.Unmarshal([]byte(reqBody.Message), &messageBody)
	if err != nil {
		s.Log.Debug("worker: failed to parse message body", reqBody.Message)
		return nil, err
	}
	userID := messageBody.UserID

	err = s.Backend.WorkerDeleteUser(r.Context(), userID)
	if err != nil {
		return nil, err
	}

	return Response{}, nil
}

// The SQS message contains a number of other metadata fields, but we don't
// use them so we only decode the message body here.
type requestBody struct {
	Message string
}

type hardDeleteUserMessage struct {
	UserID    string    `json:"user_id"`
	Timestamp time.Time `json:"timestamp"`
}
