freeStyleJob('cb-watchers-build') {
  using 'TEMPLATE-autobuild'
  concurrentBuild true

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - \${GIT_BRANCH}')
  }

  scm {
    git {
      remote {
        github 'cb/watchers', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  steps {
    shell './scripts/build.sh'

    conditionalSteps {
      condition {
        stringsMatch('${GIT_BRANCH}', 'origin/master', false)
      }
      steps {
        downstreamParameterized {
          trigger('cb-watchers-deploy') {
            block {
              buildStepFailure('FAILURE')
              failure('FAILURE')
              unstable('UNSTABLE')
            }
            parameters {
              predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
              predefinedProp('ENVIRONMENT', 'development')
            }
          }
        }
      }
    }
  }
}

freeStyleJob('cb-watchers-deploy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/watchers', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy.sh'
    shell './scripts/deploy_worker.sh'
  }
}
