#!/bin/bash
set -ex
CURRENT=$(pwd)
TAG=docker.pkgs.xarth.tv/cb/watchers:$GIT_COMMIT
WORKER_TAG=docker.pkgs.xarth.tv/cb/watchers:$GIT_COMMIT-worker

echo $CURRENT

rm -rf ./.manta

cp $AWS_CONFIG_FILE ./aws_config_file

manta -v -f build.json

echo "Service docker"
cd $CURRENT/.manta/service
docker build -t $TAG .
docker push $TAG

echo "Worker docker"
cd $CURRENT/.manta/worker
docker build -t $WORKER_TAG .
docker push $WORKER_TAG