#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

cp -R .ebextensions/ deploy/.ebextensions

cd deploy
TAG=docker.pkgs.xarth.tv/cb/watchers:$GIT_COMMIT

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "$TAG",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-watchers-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

echo "$ENVIRONMENT-web-$GIT_COMMIT"

eb deploy cb-watchers-$ENVIRONMENT-web \
  --label $ENVIRONMENT-web-$GIT_COMMIT \
  --message "$BRANCH" \
  --verbose \
  --timeout 25

echo "cb.watchers.web.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u graphite.internal.justin.tv 8125