#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

cp -R .ebextensions/ deploy/.ebextensions

cd deploy
WORKER_TAG=docker.pkgs.xarth.tv/cb/watchers:$GIT_COMMIT-worker

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "$WORKER_TAG",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-watchers-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

echo "$ENVIRONMENT-worker-$GIT_COMMIT"

eb deploy cb-watchers-$ENVIRONMENT-worker \
  --label $ENVIRONMENT-worker-$GIT_COMMIT \
  --message "$BRANCH" \
  --verbose \
  --timeout 25

echo "cb.watchers.worker.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u graphite.internal.justin.tv 8125