terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-watchers-terraform"
    key     = "cb/watchers/terraform/development"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
  }
}

module "watchers" {
  source                      = "../modules/watchers"
  instance_type               = "t2.small"
  asg_max_size                = 1
  asg_min_size                = 1
  environment                 = "development"
  aws_key_name                = "cb-watchers-development"
  allow_assume_role_arn       = "arn:aws:iam::989470033077:user/devtools-jenkins"
  hard_delete_user_arn        = "arn:aws:sns:us-west-2:641044725657:notification-user-destroyed"
  rds_backup_retention_period = 0
}

output "elb_dns_name" {
  value = module.watchers.elb_dns_name
}

output "elb_zone_id" {
  value = module.watchers.elb_zone_id
}
