variable "name" {
  type        = string
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "pagerduty_integration_url" {
  type        = string
  description = "URL for Pagerduty service integration for alarms"
}

variable "web_ebs_name" {
  type        = string
  description = "EBS name for Web environment alarms"
}

variable "web_elb_name" {
  type        = string
  description = "ELB name for Web environment alarms"
}

variable "worker_ebs_name" {
  type        = string
  description = "EBS name for Worker environment alarms"
}

resource "aws_sns_topic" "pagerduty_alarm" {
  name = "${var.name}-${var.environment}-pagerduty"
}

resource "aws_sns_topic_subscription" "pagerduty_alarm_subscription" {
  topic_arn              = aws_sns_topic.pagerduty_alarm.arn
  protocol               = "https"
  endpoint               = var.pagerduty_integration_url
  endpoint_auto_confirms = true
}
