resource "aws_db_subnet_group" "roster" {
  name = "${var.name}-${var.environment}"

  subnet_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.private_subnets,
  )

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}

resource "aws_db_instance" "primary" {
  engine            = "postgres"
  engine_version    = "9.6.11"
  instance_class    = var.rds_instance
  storage_type      = "gp2"
  multi_az          = true
  allocated_storage = var.rds_storage

  identifier = "${var.name}-${var.environment}"
  name       = "watchers"
  username   = "master"
  password   = "temporary"

  publicly_accessible = false

  vpc_security_group_ids = split(",",
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  )

  port                 = 5432
  db_subnet_group_name = aws_db_subnet_group.roster.name
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  backup_retention_period = var.rds_backup_retention_period
  backup_window           = "02:00-04:00"

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}

resource "aws_db_instance" "replica" {
  replicate_source_db = aws_db_instance.primary.id

  instance_class    = var.rds_instance
  storage_type      = "gp2"
  allocated_storage = var.rds_storage

  identifier          = "${aws_db_instance.primary.id}-replica"
  name                = aws_db_instance.primary.name
  deletion_protection = true

  publicly_accessible = false

  vpc_security_group_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  )

  port                 = aws_db_instance.primary.port
  monitoring_interval  = 5
  monitoring_role_arn  = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  parameter_group_name = "pg-stat-statements-postgres-9-6"
}
