resource "aws_sqs_queue" "worker_queue" {
  name = "${var.name}-${var.environment}-worker-queue"

  visibility_timeout_seconds = 60
  message_retention_seconds  = 7200

  redrive_policy = <<EOF
{
  "maxReceiveCount":5,
  "deadLetterTargetArn": "${aws_sqs_queue.worker_queue_dlq.arn}"
}
EOF

  lifecycle {
    prevent_destroy = true
  }
}

resource "aws_sqs_queue" "worker_queue_dlq" {
  name                      = "${var.name}-${var.environment}-worker-queue-dlq"
  message_retention_seconds = 345600

  lifecycle {
    prevent_destroy = true
  }
}

resource "aws_sqs_queue_policy" "worker_queue_permissions" {
  queue_url = aws_sqs_queue.worker_queue.id

  # Define SNS topics that may publish to this SQS queue
  policy = <<POLICY
{
  "Version": "2012-10-17",
  "Id": "${aws_sqs_queue.worker_queue.arn}/SQSDefaultPolicy",
  "Statement": [
    {
      "Sid": "${var.hard_delete_user_arn}-send-message",
      "Effect": "Allow",
      "Principal": {
        "AWS": "*"
      },
      "Action": "SQS:SendMessage",
      "Resource": "${aws_sqs_queue.worker_queue.arn}",
      "Condition": {
        "ArnEquals": {
          "aws:SourceArn": [
            "${var.hard_delete_user_arn}"
          ]
        }
      }
    }
  ]
}
POLICY
}

resource "aws_sns_topic_subscription" "hard_delete_user_sns" {
  topic_arn = var.hard_delete_user_arn
  protocol  = "sqs"
  endpoint  = aws_sqs_queue.worker_queue.arn
}
