terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-watchers-terraform"
    key     = "cb/watchers/terraform/production"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
  }
}

module "watchers" {
  source                      = "../modules/watchers"
  instance_type               = "c4.large"
  rds_instance                = "db.m4.xlarge"
  asg_max_size                = 4
  asg_min_size                = 2
  environment                 = "production"
  aws_key_name                = "cb-watchers-production"
  hard_delete_user_arn        = "arn:aws:sns:us-west-2:641044725657:notification-user-destroyed"
  rds_storage                 = 1000
  rds_backup_retention_period = 7
  sandstorm_role_arn          = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-watchers-production"

  vpce_allowed_principals = [
    "arn:aws:iam::737882373154:root", # boba-prod
  ]
}

module "alarms" {
  name                      = "cb-watchers"
  source                    = "../modules/alarms"
  environment               = "production"
  pagerduty_integration_url = "https://events.pagerduty.com/integration/a27ef913a05149e9a86e114aeb77d074/enqueue"
  web_ebs_name              = module.watchers.web_ebs_name
  web_elb_name              = module.watchers.web_elb_name
  worker_ebs_name           = module.watchers.worker_ebs_name
}
