terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-watchers-terraform"
    key     = "cb/watchers/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
  }
}

module "watchers" {
  source                      = "../modules/watchers"
  instance_type               = "t2.small"
  asg_max_size                = 1
  asg_min_size                = 1
  environment                 = "staging"
  aws_key_name                = "cb-watchers-staging"
  hard_delete_user_arn        = "arn:aws:sns:us-west-2:465369119046:notification-user-destroyed"
  rds_backup_retention_period = 15
  sandstorm_role_arn          = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-watchers-staging"

  vpce_allowed_principals = [
    "arn:aws:iam::726281605084:root", # boba-dev
  ]
}
