
export interface Badge {
  id: string;
  name: string;
  required_xp: number;
  selected?: boolean;
  evolution?: string;
}

export interface Evolution {
  id: string;
  name: string;
  badges?: Badge[];
  current_xp?: number;
  selected?: boolean;
}

export interface EvolutionSet {
  id: string;
  name: string;
  evolutions: Evolution[];
}

export type Page = 'LOADING' | 'SELECT' | 'PROGRESS';
export const PAGES: {[key: string]: Page} = {
  LOADING: 'LOADING',
  SELECT: 'SELECT',
  PROGRESS: 'PROGRESS',
};

export const BADGE_ASSETS = 'static/assets/';
export const BADGE_PREFIX = 'pokemon_badge_';
export const BADGE_SIZES: {[key: string]: string} = {
  small: '18x18',
  medium: '36x36',
  large: '72x72',
};
