import * as React from 'react';
import { Badge, BADGE_ASSETS, BADGE_PREFIX, BADGE_SIZES } from 'common/constants';
require('./styles.scss');

export interface BadgeDisplayProps {
  badge: Badge;
  size: 'small' | 'medium' | 'large';
  selected?: boolean;
  onClick?: () => {};
}

export class BadgeDisplay extends React.Component<BadgeDisplayProps, {}> {
  public render() {
    const { badge, size, selected, onClick } = this.props;
    const badgeImageString = this.getImage();
    const badgeDisplay = `badge-display--${size}`;
    const badgeClasses = ['badge-display', badgeDisplay];
    if (selected !== undefined) {
      badgeClasses.push(selected ? 'badge-display--selected' : 'badge-display--not-selected');
    }
    const parentProps: any = {};
    if (onClick !== undefined) {
      parentProps.onClick = onClick;
    }

    return (
      <div className={badgeClasses.join(' ')} {...parentProps}>
        <img src={badgeImageString} className="badge-display__image" />
      </div>
    );
  }

  private getImage() {
    const { badge, size } = this.props;
    const badgeName = badge.name.toLowerCase();
    const sizeString = BADGE_SIZES[size];
    return `${BADGE_ASSETS}${BADGE_PREFIX}${badgeName}_${sizeString}.png`;
  }
}
