import * as React from 'react';
import { Evolution, Badge } from 'common/constants';
import { BadgeDisplay } from 'ui/components/Badge';
require('./styles.scss');

export interface ProgressProps {
  currentEvolution: Evolution;
  currentBadge: Badge;
  toSelect: () => void;
}

export class ProgressPage extends React.Component<ProgressProps, {}> {
  public render() {
    const { currentBadge, currentEvolution, toSelect } = this.props;
    return (
      <div className="progress__container">
        <div className="progress__character">
          <BadgeDisplay badge={currentBadge} size="large" />
        </div>
        <div className="progress__current-xp">
          {currentEvolution.current_xp}
        </div>
        <button onClick={toSelect}>Change Pokemon</button>
      </div>
    );
  }
}
