import * as React from 'react';

import { Evolution, Badge } from 'common/constants';
import { BadgeDisplay } from 'ui/components/Badge';
require('./styles.scss');

export interface SelectProps {
  badges: Badge[];
  setBadge: (badge: Badge) => {};
}
export interface SelectState {
  selectedBadge: Badge;
}

export class SelectPage extends React.Component<SelectProps, SelectState> {
  public constructor(props: SelectProps) {
    super(props);
    const selectedBadge = this.props.badges.find((badge: Badge) => badge.selected);
    this.state = {
      selectedBadge
    };
  }

  public render() {
    const { badges, setBadge } = this.props;
    const { selectedBadge } = this.state;
    const selectableBadges = badges.map((badge: Badge) => {
      const selectBadge = this.selectBadge.bind(this, badge);
      return (
        <BadgeDisplay
          key={badge.id}
          badge={badge}
          size="large"
          selected={badge === selectedBadge}
          onClick={selectBadge}
        />
      );
    });

    const confirmBadge = this.confirmBadge.bind(this);
    return (
      <div className="select-evolution__container">
        {selectableBadges}
        <button onClick={confirmBadge}>Confirm</button>
      </div>
    );
  }

  private selectBadge(badge: Badge) {
    this.setState({
      selectedBadge: badge
    });
  }

  private confirmBadge() {
    this.props.setBadge(this.state.selectedBadge);
  }
}
