const EVOLUTION_SETS = {
  1: {
    "id": 1,
    "name": "Pokemon"
  }
};

const EVOLUTIONS = {
  1: {
    "id": 1,
    "evolution_set": 1,
    "name": "Bulbasaur",
  },
  2: {
    "id": 2,
    "evolution_set": 1,
    "name": "Squirtle",
  },
  3: {
    "id": 3,
    "evolution_set": 1,
    "name": "Charmander",
  },
};

const BADGES = {
  1: {
    "id": 1,
    "evolution": 1,
    "name": "Bulbasaur",
    "required_xp": 0,
  },
  2: {
    "id": 2,
    "evolution": 1,
    "name": "Ivysaur",
    "required_xp": 3000,
  },
  3: {
    "id": 3,
    "evolution": 1,
    "name": "Venusaur",
    "required_xp": 6000,
  },
  4: {
    "id": 4,
    "evolution": 2,
    "name": "Squirtle",
    "required_xp": 0,
  },
  5: {
    "id": 5,
    "evolution": 2,
    "name": "Wartortle",
    "required_xp": 3000,
  },
  6: {
    "id": 6,
    "evolution": 2,
    "name": "Blastoise",
    "required_xp": 6000,
  },
  7: {
    "id": 7,
    "evolution": 3,
    "name": "Charmander",
    "required_xp": 0,
  },
  8: {
    "id": 8,
    "evolution": 3,
    "name": "Charmeleon",
    "required_xp": 3000,
  },
  9: {
    "id": 9,
    "evolution": 3,
    "name": "Charizard",
    "required_xp": 6000,
  },
};

// const hasManyRelations = {
//   'evolution_set': 'evolution',
//   'evolution': 'badges',
// };

module.exports = () => {
  const evolution_sets = Object.values(EVOLUTION_SETS).map((evo_set) => {
    const evolutions = Object.values(EVOLUTIONS)
      .filter((evo) => evo.evolution_set === evo_set.id)
      .map((evo) => {
        const badges = Object.values(BADGES)
          .filter((badge) => badge.evolution === evo.id);
        return {
          ...evo,
          badges,
        };
      });
    return {
      ...evo_set,
      evolutions,
    };
  });

  const users = {
    1: {
      id: 1,
      name: 'Lak',
      evolutions: [{
        ...EVOLUTIONS[1],
        current_xp: 300
      }, {
        ...EVOLUTIONS[2],
        current_xp: 7000,
        selected: true,
      }, {
        ...EVOLUTIONS[3],
        current_xp: 3200
      }],
      badges: [
        BADGES[1],
        {
          ...BADGES[6],
          selected: true,
        },
        BADGES[8]
      ]
    },
    2: {
      id: 2,
      name: 'Fyrn',
      evolutions: [{
        ...EVOLUTIONS[1],
        current_xp: 7000
      }, {
        ...EVOLUTIONS[2],
        current_xp: 4000,
        selected: true,
      }, {
        ...EVOLUTIONS[3],
        current_xp: 7000
      }],
      badges: [
        BADGES[3],
        {
          ...BADGES[5],
          selected: true,
        },
        BADGES[9]
      ]
    }
  }

  return {
    evolution_sets,
    users: [users[1], users[2]]
  };
}
