# evo

Backend components for Promotional Loyalty Badges.

Product Spec: [Google Docs](https://docs.google.com/document/d/1CcarzNKwb5tbOSfOFYf5x0IC4KPp4-ESM1oLESuAsPw/edit)  
Tech Spec: [Google Docs](https://docs.google.com/document/d/1Q8ogkdYCGCVV8uZNZ5PMGY1XUI8SD-HK48vZMkDaJ8I/edit)

This repo contains:
- **evo-api:** the Extension Backend Service for the evo extension
- **evo-mw:** the minutes-watched event ingestion service


## Invocation

Proper configuration is currently non-existent, and just based on env vars.

Both binaries need `$DATABASE_URL`.

`evo-mw` also needs [AWS credentials](https://docs.aws.amazon.com/sdk-for-go/api/aws/session/#hdr-Environment_Variables),
for which the most straightforward options seem to be:
- `$AWS_SHARED_CREDENTIALS_FILE` and `$AWS_PROFILE`
- `$AWS_ACCESS_KEY` and `$AWS_SECRET_ACCESS_KEY`

With those environment variables exported, run whichever binary without any arguments.


## Local Development

### Dependencies

- [Go](https://golang.org/) version >= 1.9
- [Glide](https://glide.sh/), a package management tool for Go
- [Postgres](https://www.postgresql.org/)
- (soon) [Docker](https://www.docker.com/) and [Docker Compose](https://docs.docker.com/compose/)

### Project Workspace

Due to the project directory hierarchy Go requires, you cannot simply `git clone` this repo;
it must be cloned into an existing [Go Workspace](https://golang.org/doc/code.html#Workspaces).

Here's how I've set mine up:

    # create the Go workspace:
    ~$ mkdir ~/work/evo
    ~$ cd ~/work/evo
    
    # clone this repo under src/ and its full Go package path
    ~/work/evo$ git clone 'git@git-aws.internal.justin.tv:content/evo' src/code.justin.tv/content/evo
    
    # define and export $GOPATH
    # (this variable is required by pretty much all Go tools, including `go` and `glide`)
    ~/work/evo$ export GOPATH="$PWD"
    
    # (optional) create a symlink, since it's most convenient to do dev work from the repo directory
    ~/work/evo$ ln -s src/code.justin.tv/content/evo evo
    
    # cd to the repo and get its dependencies
    ~/work/evo$ cd evo # or `cd src/code.justin.tv/content/evo` if you symlink it
    ~/work/evo/evo$ glide install

From then on, it's easiest to work within the repo directory, but make sure your `$GOPATH` is
exported and refers to the root directory of the _Go workspace_ (`~/work/evo` in the above example),
and not to the repo.

### Compile

If `$GOPATH` is exported as the Go workspace root, it's easiest to be in the repo directory and call
`go install` with a relative package path:  

    ~/work/evo/evo$ go install app/...
    # (equivalent to: `go install code.justin.tv/content/evo/app/...`)

The resulting binaries (`evo-api` and `evo-mw`) will be in `$GOPATH/bin/`.  
Some developers like to `export PATH="$GOPATH/bin:$PATH"` immediately after they define `$GOPATH`.

The first compilation after fetching dependencies will take a while. Compiled libraries live in `$GOPATH/pkg/`.

### Test

This project uses conditional compilation to prevent test support code from being released.  
Make sure to include the `test` tag when compiling.  

    ~/work/evo/evo$ go test -tags test -test.v ./...
